package DTCDemo;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import net.miginfocom.swing.MigLayout;
import SDK.SDKlib;
import SDK.SDKlib.Action;
import SDK.SDKlib.ConnectionType;
import SDK.SDKlib.InfoMask;
import SDK.SDKlib.Model;
import SDK.SDKlib.PrinterInfo;
import SDK.SDKlib.PrinterType;
import SDK.SDKlib.Pro360Param;
import SDK.SDKlib.Password;
import SDK.SDKlib.Return;
import SDK.SDKlib.SDKVersion;
import SDK.SDKlib.Sensors;
import SDK.SDKlib.SmartMode;
import SDK.SDKlib.Status;

import com.sun.jna.platform.win32.WinNT.HANDLE;
import com.sun.jna.platform.win32.WinDef.BOOLByReference;
import com.sun.jna.ptr.IntByReference;

import javax.swing.border.TitledBorder;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import static DTCDemo.Utils.*;
import static DTCDemo.Main.tabbedPane;

//====================================================================================

class Info {
	private final String SDKBITS    = "SDKBITS";
	private final String LASTMSG    = "LASTMSG";
	private final String STATUS     = "STATUS";
	private final String INFO       = "INFO";
	private final String VERSION    = "VERSION";
	private final String CONNECTION = "CONNECTION";
	private final String TYPE       = "TYPE";
	private final String MODEL      = "MODEL";
	private final String PASSWORD   = "PASSWORD";
	private final String PWDCMD     = "PWDCMD";
	private final String CLEAR      = "CLEAR";
	private final String READ360    = "READ360";
	private final String ALL360     = "ALL360";
	private final String SENSORS    = "SENSORS";

	private final ActionHandler ah = new ActionHandler();
	
	public static final JPanel panelInfo = new JPanel();

	private final JButton btnLastMessage = new JButton("Last Message");
	private final JButton btnPrinterStatus = new JButton("Printer Status");
	private final JButton btnPrinterInfo = new JButton("Printer Info");
	private final JButton btnSDKVersion = new JButton("SDK Version");
	private final JButton btnConnectionType = new JButton("Connection Type");
    private final JButton btnPrinterType = new JButton("Printer Type");
	private final JButton btnPrinterModel = new JButton("Printer Model");
    private final JButton btnSDKBits = new JButton("SDK Bits");
    private final JButton btnClear = new JButton("Clear");

	private final JPanel panelPassword = new JPanel();
	private final JComboBox<ComboItem> comboPassword = new JComboBox<>();
	private final JLabel labelPassword1 = new JLabel("P1");
	private final JLabel labelPassword2 = new JLabel("P2");
	private final JButton btnPassword = new JButton("Send");
	private final JTextField editPassword1 = new JTextField();
	private final JTextField editPassword2 = new JTextField();
    
    private final JTextArea textInfoMsg = new JTextArea();
    private final JScrollPane scrollPane = new JScrollPane();

    private final JPanel panelPro360 = new JPanel();
    private final JLabel labelParameter = new JLabel("Parameter");
    private final JComboBox<ComboItem> comboParam360 = new JComboBox<ComboItem>();
    private final JButton btnRead360 = new JButton("Read");
    private final JButton btnAllParams = new JButton("All Params");

    private HANDLE hSession;
    private SDKlib SDK;
    
    //====================================================================================

    enum ParamType { AsBool, AsInt, AsString };

    class Param360 {
        public String    Text;
    	public byte      ID;
        public ParamType Type;

	    // constructor
	    public Param360(String param, byte ID, ParamType paramType) {
	       this.Text = param;
	       this.ID   = ID;
	       this.Type = paramType;
	    }
    }
    
    Param360[] ParamSet = {
    	new Param360("Duplex",				 Pro360Param.CapabilityDuplex,		 ParamType.AsBool), 
    	new Param360("Mag Encoding",		 Pro360Param.CapabilityMag,			 ParamType.AsBool), 
    	new Param360("Smart Encoding",		 Pro360Param.CapabilitySmart,		 ParamType.AsBool), 
    	new Param360("System Version",		 Pro360Param.SystemVersion,			 ParamType.AsString), 
    	new Param360("Printer App Vers.",	 Pro360Param.PrinterAppVersion,		 ParamType.AsString), 
    	new Param360("Firmware Version",	 Pro360Param.FirmwareVersion,		 ParamType.AsString), 
    	new Param360("Mag Firmware Vers.",	 Pro360Param.MagFirmwareVersion,	 ParamType.AsString), 
    	new Param360("Printer Serial",		 Pro360Param.PrinterSerial,			 ParamType.AsString), 
    	new Param360("Printhead Serial",	 Pro360Param.PrintheadSerial,		 ParamType.AsString), 
    	new Param360("Main Board Serial",	 Pro360Param.BoardSerial,			 ParamType.AsString), 
    	new Param360("Model Name",			 Pro360Param.ModelName,				 ParamType.AsString), 
    	new Param360("Dealer Code",			 Pro360Param.DealerCode,			 ParamType.AsInt), 
    	new Param360("Project Code",		 Pro360Param.ProjectCode,			 ParamType.AsInt), 
    	new Param360("Total Cards",			 Pro360Param.TotalCards,			 ParamType.AsInt), 
    	new Param360("Total Panels",		 Pro360Param.TotalPanels,			 ParamType.AsInt), 
    	new Param360("Cards on Printhead",	 Pro360Param.CardsOnPrinthead,		 ParamType.AsInt), 
    	new Param360("Panels on Printhead",	 Pro360Param.PanelsOnPrinthead,		 ParamType.AsInt), 
    	new Param360("Cards since Clean",	 Pro360Param.CardsSinceClean,		 ParamType.AsInt), 
    	new Param360("Panels since Clean",	 Pro360Param.PanelsSinceClean,		 ParamType.AsInt), 
    	new Param360("Cleaning Cycles",		 Pro360Param.Cleans,				 ParamType.AsInt), 
    	new Param360("Dyefilm Name",		 Pro360Param.DyeFilmName,			 ParamType.AsString), 
    	new Param360("Dyefilm Serial",		 Pro360Param.DyeFilmSerial,			 ParamType.AsString), 
    	new Param360("Dyefilm Prints",		 Pro360Param.DyeFilmTotalPrints,	 ParamType.AsInt), 
    	new Param360("Dyefilm Prints Left",	 Pro360Param.DyeFilmPrintsRemaining, ParamType.AsInt), 
    	new Param360("Dyefilm Manu.",		 Pro360Param.DyeFilmManufacturer,	 ParamType.AsInt), 
    	new Param360("Cards between Cleans", Pro360Param.CleansInterval,		 ParamType.AsInt), 
    	new Param360("Clean Overdue",		 Pro360Param.CleanOverdue,			 ParamType.AsBool), 
    	new Param360("MAC Address",			 Pro360Param.MACAddress,			 ParamType.AsString), 
    	new Param360("Use DHCP",			 Pro360Param.UseDHCP,				 ParamType.AsBool), 
    	new Param360("IP Address",			 Pro360Param.DynamicIPAddress,		 ParamType.AsString), 
    	new Param360("IP Gateway",			 Pro360Param.DynamicGateway,		 ParamType.AsString), 
    	new Param360("IP Subnet",			 Pro360Param.DynamicSubnet,			 ParamType.AsString), 
    	new Param360("Static IP Address",	 Pro360Param.StaticIPAddress,		 ParamType.AsString), 
    	new Param360("Static IP Gateway",	 Pro360Param.StaticGateway,			 ParamType.AsString), 
    	new Param360("Static IP Subnet",	 Pro360Param.StaticSubnet,			 ParamType.AsString), 
    	new Param360("Error Status",		 Pro360Param.ErrorCode,				 ParamType.AsString), 
    	new Param360("Hand Feed",			 Pro360Param.HandFeed,				 ParamType.AsBool), 
    	new Param360("Card Position",		 Pro360Param.CardLocation,			 ParamType.AsString), 
    	new Param360("Mag Enc. Start",		 Pro360Param.MagStart,				 ParamType.AsInt), 
    	new Param360("Dyefilm YMC Length",	 Pro360Param.ColourLength,			 ParamType.AsInt), 
    	new Param360("Dyefilm K Length",	 Pro360Param.BlackLength,			 ParamType.AsInt), 
    	new Param360("Dyefilm O Length",	 Pro360Param.OverlayLength,			 ParamType.AsInt), 
    	new Param360("Contactless Offset",	 Pro360Param.SmartOffset,			 ParamType.AsInt),
    	new Param360("HoloKote Slots",	     Pro360Param.HoloKoteCount,			 ParamType.AsInt),
    	new Param360("600 dpi",	             Pro360Param.Capability600dpi,		 ParamType.AsBool),
    	new Param360("Hopper Sensor",	     Pro360Param.HopperSensor,  		 ParamType.AsBool),
    	new Param360("Exit Sensor",	         Pro360Param.ExitSensor,			 ParamType.AsBool),
    	new Param360("Lid Sensor",	         Pro360Param.LidSensor,     		 ParamType.AsBool),
        new Param360("Manufacturer",         Pro360Param.Manufacturer,			 ParamType.AsString), 
        new Param360("Hopper Sensor Fitted", Pro360Param.HopperSensorFitted,	 ParamType.AsBool), 
        new Param360("Exit Sensor Fitted",   Pro360Param.ExitSensorFitted,		 ParamType.AsBool), 
        new Param360("Region",               Pro360Param.Region,				 ParamType.AsInt), 
    };
    private final JButton btnSensors = new JButton("Sensors");

    //====================================================================================

	public Info() {
		panelInfo.setLayout(new MigLayout("", "[129.00][grow]", "[][][][][][][][][][][][397.00][397.00,grow][]"));

        panelInfo.add(panelPassword, "cell 0 0 2 1,grow");
        panelPassword.setLayout(new MigLayout("", "[grow]", "[]"));
        panelPassword.setBorder(new TitledBorder(null, 
        		                                 "Password", 
        		                                 TitledBorder.LEADING, 
        		                                 TitledBorder.TOP, 
        		                                 null, 
        		                                 null));
        
        panelPassword.add(comboPassword, "flowx,cell 0 0,growx");
        comboPassword.addItem(new ComboItem("Set", Password.SET));
        comboPassword.addItem(new ComboItem("Use", Password.USE));
        comboPassword.setActionCommand(PWDCMD);
        comboPassword.addActionListener(ah);
        
        panelPassword.add(labelPassword1, "cell 0 0");
        panelPassword.add(editPassword1, "cell 0 0");
        panelPassword.add(labelPassword2, "cell 0 0");
        panelPassword.add(editPassword2, "cell 0 0");
        
		editPassword1.setColumns(10);
		editPassword2.setColumns(10);
		
        panelInfo.add(scrollPane, "cell 1 1 1 12,grow");
        textInfoMsg.setEditable(false);
        scrollPane.setViewportView(textInfoMsg);

		btnPassword.setActionCommand(PASSWORD);
        btnPassword.addActionListener(ah);
        panelPassword.add(btnPassword, "cell 0 0");
        
        panelInfo.add(btnSDKVersion, "cell 0 1,growx");
        btnSDKVersion.setActionCommand(VERSION);
        btnSDKVersion.addActionListener(ah);
        
        panelInfo.add(btnSDKBits, "cell 0 2,growx");
        btnSDKBits.setActionCommand(SDKBITS);
        btnSDKBits.addActionListener(ah);

        panelInfo.add(btnConnectionType, "cell 0 3,growx");
        btnConnectionType.setActionCommand(CONNECTION);
        btnConnectionType.addActionListener(ah);
        
        panelInfo.add(btnPrinterType, "cell 0 4,growx");
        btnPrinterType.setActionCommand(TYPE);
        btnPrinterType.addActionListener(ah);

        panelInfo.add(btnPrinterModel, "cell 0 5,growx");
        btnPrinterModel.setActionCommand(MODEL);
        btnPrinterModel.addActionListener(ah);
                
        panelInfo.add(btnPrinterStatus, "cell 0 6,growx");
        btnPrinterStatus.setActionCommand(STATUS);
        btnPrinterStatus.addActionListener(ah);
                
        panelInfo.add(btnPrinterInfo, "cell 0 7,growx");
        btnPrinterInfo.setActionCommand(INFO);
        btnPrinterInfo.addActionListener(ah);

        panelInfo.add(btnLastMessage, "cell 0 8,growx");
        btnLastMessage.setActionCommand(LASTMSG);
        btnLastMessage.addActionListener(ah);
        
        panelInfo.add(btnSensors, "cell 0 9,growx");
        btnSensors.setActionCommand(SENSORS);
        btnSensors.addActionListener(ah);
        
        panelPro360.setBorder(new TitledBorder(null, "Rio Pro 360 Settings", TitledBorder.LEADING, TitledBorder.TOP, null, null));
        
        panelInfo.add(panelPro360, "cell 0 12,grow");
        panelPro360.setLayout(new MigLayout("", "[grow]", "[][][][grow][grow][]"));
        labelParameter.setHorizontalAlignment(SwingConstants.CENTER);
        
        panelPro360.add(labelParameter, "cell 0 0,growx");
        panelPro360.add(comboParam360, "cell 0 1,growx");
        
        panelPro360.add(btnRead360, "cell 0 2,alignx center");
        btnRead360.setActionCommand(READ360);
        btnRead360.addActionListener(ah);
		for (Param360 item : ParamSet) {
			comboParam360.addItem(new ComboItem(item.Text, item.ID));
		}

        panelPro360.add(btnAllParams, "cell 0 5,alignx center");
        btnAllParams.setActionCommand(ALL360);
        btnAllParams.addActionListener(ah);
        
        panelInfo.add(btnClear, "cell 1 13,alignx center");
		btnClear.setActionCommand(CLEAR);
		btnClear.addActionListener(ah);
    }
	
	//====================================================================================

	void Init(HANDLE handle, SDKlib sdk) {
		tabbedPane.addTab("Information", null, panelInfo, null);

		this.hSession = handle;
    	this.SDK = sdk;

		boolean bControl = (connectedPrinter != PrinterType.GENERATION2);
		btnPassword.setEnabled(bControl);
		editPassword1.setEnabled(bControl);
		editPassword2.setEnabled(bControl);
		comboPassword.setEnabled(bControl);
		labelPassword1.setEnabled(bControl);
		labelPassword2.setEnabled(bControl);

		panelPro360.setVisible(!bControl);
		labelParameter.setVisible(!bControl);
		btnRead360.setVisible(!bControl);
		btnAllParams.setVisible(!bControl);
		comboParam360.setVisible(!bControl);
	}
	
	//------------------------------------------------------------------------------------

	void ClearMsg() {
		textInfoMsg.setText(null);
	}
	
	//====================================================================================

	private void SDKBits() {
		textInfoMsg.append(SDK.ID_SDKBits() + " Bit SDK\n\n");
	}
	
	//------------------------------------------------------------------------------------

	private void LastMsg() {
		StringBuilder Message = new StringBuilder();
		byte sdkReturn = SDK.ID_LastMessage(hSession, Message);
		if (sdkReturn != Return.SUCCESS) {
			DisplayError("GetLastMessage", sdkReturn);
		}
		else {
			textInfoMsg.append(Message.toString() + "\n\n");
		}
	}
	
	//------------------------------------------------------------------------------------

	private void PrinterStatus() {
		String temp_string = "";
		switch (SDK.ID_PrinterStatus(hSession)) {
		case Status.READY:   temp_string = "READY";   break;
		case Status.OFFLINE: temp_string = "OFFLINE"; break;
		case Status.ERROR:   temp_string = "ERROR";   break;
		case Status.BUSY:    temp_string = "BUSY";    break;
		}

		textInfoMsg.append("Printer is " + temp_string + "\n\n");
	}
	
	//------------------------------------------------------------------------------------

	private void PrinterInfo() {
		CursorWait();
		
		PrinterInfo PI = new PrinterInfo();
		byte sdkReturn = SDK.ID_PrinterInfo(hSession, PI);
		if (sdkReturn != Return.SUCCESS) {
			DisplayError("GetPrinterInfo", sdkReturn);
		}
		else {
			textInfoMsg.append("PrinterConnected: "    + (PI.printerConnected ? "Yes" : "No") + "\n");
			textInfoMsg.append("Model Code: "          + PI.modelCode + "\n");
			textInfoMsg.append("Model: "               + new String(PI.model) + "\n");
			textInfoMsg.append("PrintheadType: "       + PI.printheadType + "\n");
			textInfoMsg.append("PrinterSerial: "       + new String(PI.printerSerial) + "\n");
			textInfoMsg.append("PrintheadSerial: "     + new String(PI.printheadSerial) + "\n");
			textInfoMsg.append("PCBSerial: "           + new String(PI.pcbSerial) + "\n");
			textInfoMsg.append("FirmwareVersion: "     + new String(PI.firmware) + "\n");
			textInfoMsg.append("Density: "             + PI.density + "\n");
			textInfoMsg.append("HandFeed: "            + OnOffString(PI.handFeed != 0) + "\n");
			textInfoMsg.append("CardsPrinted: "        + PI.cardsPrinted + "\n");
			textInfoMsg.append("CardsOnPrinthead: "    + PI.cardsOnPrinthead + "\n");
			textInfoMsg.append("DyePanelsPrinted: "    + PI.dyePanelsPrinted + "\n");
			textInfoMsg.append("CleansSinceShipped: "  + PI.cleansSinceShipped + "\n");
			textInfoMsg.append("DyePanelsSinceClean: " + PI.dyePanelsSinceClean + "\n");
			textInfoMsg.append("CardsSinceClean: "     + PI.cardsSinceClean + "\n");
			textInfoMsg.append("CardsBetweenCleans: "  + PI.cardsBetweenCleans + "\n");
			textInfoMsg.append("PrintHeadPosn: "       + PI.printHeadPosn + "\n");
			textInfoMsg.append("ImageStartPosn: "      + PI.imageStartPosn + "\n");
			textInfoMsg.append("ImageEndPosn: "        + PI.imageEndPosn + "\n");
			textInfoMsg.append("MajorError: "          + PI.majorError + "\n");
			textInfoMsg.append("MinorError: "          + PI.minorError + "\n");
			textInfoMsg.append("TagUID: "              + new String(PI.tagUID) + "\n");
			textInfoMsg.append("ShotsOnFilm: "         + PI.shotsOnFilm + "\n");
			textInfoMsg.append("ShotsUsed: "           + PI.shotsUsed + "\n");
			textInfoMsg.append("DyeFilmType: "         + new String(PI.dyeFilmType) + "\n");
			textInfoMsg.append("DyeFilmManuf: "        + PI.dyeFilmManuf + "\n");
			textInfoMsg.append("ColourLength: "        + PI.colourLength + "\n");
			textInfoMsg.append("ResinLength: "         + PI.resinLength + "\n");
			textInfoMsg.append("OvercoatLength: "      + PI.overcoatLength + "\n");
			textInfoMsg.append("DyeFlags: "            + PI.dyeFlags + "\n");
			textInfoMsg.append("CommandCode: "         + PI.commandCode + "\n");
			textInfoMsg.append("DOB: "                 + PI.dob + "\n");
			textInfoMsg.append("DyeFilmProg: "         + PI.dyeFilmProg + "\n");
			textInfoMsg.append("Smart Mode: ");
			switch (PI.bitFields & InfoMask.ENCODE_MODE)
			{
			case InfoMask.ENCODE_PLATEN:
				textInfoMsg.append(Printer.SmartModeString(SmartMode.PLATEN) + "\n");
				break;
			case InfoMask.ENCODE_XLI:    
				textInfoMsg.append(Printer.SmartModeString(SmartMode.XLI) + "\n");     
				break;
			default:					 
				textInfoMsg.append(Printer.SmartModeString(SmartMode.DEFAULT) + "\n"); 
				break;
			}
			textInfoMsg.append("Smart Offset: "    + PI.smartOffset + "\n");
			textInfoMsg.append("Eject Mode: "      + OnOffString((PI.bitFields & InfoMask.EJECT_MODE) != 0) + "\n");
			textInfoMsg.append("Horz Eject Mode: " + OnOffString((PI.bitFields & InfoMask.HORZ_EJECT) != 0) + "\n");
			textInfoMsg.append("Erase Speed: "     + ((PI.bitFields & InfoMask.ERASE_SPEED) != 0 ? "Quick" : "Thorough") + "\n");
			textInfoMsg.append("\n");
		}

		CursorDefault();
	}
	
	//------------------------------------------------------------------------------------

	private void SDKVersion() {
		SDKVersion version = new SDKVersion();
		byte sdkReturn = SDK.ID_SDKVersion(hSession, version);
		if (sdkReturn != Return.SUCCESS) {
			DisplayError("GetVersion", sdkReturn);
		}
		else {
			textInfoMsg.append("Version: " + version.major   + "."
										   + version.minor   + "."
										   + version.build   + "." 
										   + version.beta + "\n\n");
		}
	}
	
	//------------------------------------------------------------------------------------

	private void Connection() {
		String msg;
		switch (SDK.ID_ConnectionType(hSession)) {
		case ConnectionType.USB: 	  msg = "USB";      break;
		case ConnectionType.ETHERNET: msg = "ETHERNET"; break;
		case ConnectionType.FILE:     msg = "FILE";     break;
		default:                      msg = "UNKNOWN";  break;
		}
        textInfoMsg.append("Connection: " + msg + "\n\n");
	}
	
	//------------------------------------------------------------------------------------

	private void Type() {
		textInfoMsg.append("Printer Type - ");
        switch (SDK.ID_PrinterType(hSession))
        {
            case PrinterType.RIO:         textInfoMsg.append("RioTango\n\n");            break;
            case PrinterType.AOTA:        textInfoMsg.append("AOTA\n\n");                break;
            case PrinterType.ENDURO:      textInfoMsg.append("Enduro Family\n\n");       break;
            case PrinterType.ULTIMA:      textInfoMsg.append("Ultima\n\n");              break;
            case PrinterType.GENERATION2: textInfoMsg.append("Generation 2 Family\n\n"); break;
            default:                      textInfoMsg.append("UNKNOWN\n\n");             break;
        }
	}
		
	//------------------------------------------------------------------------------------

	private void Model() {
    	String msg;
        int model = SDK.ID_PrinterModel(hSession);
        if      ((model & Model.PRONTO)  != 0)     msg = "Pronto";
        else if ((model & Model.RIO_PRO) != 0)     msg = "Rio Pro";
        else if ((model & Model.ULTIMA)  != 0)     msg = "Ultima";
        else if ((model & Model.ENDURO)  != 0)     msg = "Enduro";
        else if ((model & Model.RIO_PRO360) != 0)  msg = "Rio Pro 360";
        else if ((model & Model.MODEL600) != 0)    msg = "600";
        else if ((model & Model.MODEL300) != 0)    msg = "300";
        else if ((model & Model.PRONTO100) != 0)   msg = "Pronto 100";
        else if ((model & Model.GENERATION2) != 0) msg = "Generation 2";
        else                                       msg = "UNKNOWN";
        textInfoMsg.append("Printer - " + msg + "\n");

        textInfoMsg.append("Capability:\n");
        if ((model & Model.MAGNETIC)    != 0) textInfoMsg.append("  - Mag Encoding\n");
        if ((model & Model.DUPLEX)      != 0) textInfoMsg.append("  - Duplex\n");
        if ((model & Model.REWRITE)     != 0) textInfoMsg.append("  - Rewrite\n");
        if ((model & Model.CHIP)        != 0) textInfoMsg.append("  - Chip Encoding\n");
        if ((model & Model.CONTACTLESS) != 0) textInfoMsg.append("  - Contactless Encoding\n");
        if ((model & Model.EXTENDED)    != 0) textInfoMsg.append("  - Extended\n");
        if ((model & Model.ETHERNET)    != 0) textInfoMsg.append("  - Ethernet\n");
        if ((model & Model.DPI600)      != 0) textInfoMsg.append("  - 600 dpi\n");
        textInfoMsg.append("\n");
	}
	
	//------------------------------------------------------------------------------------

	private void Password() {
		byte sdkReturn = SDK.ID_Password(hSession, 
				                         ((ComboItem)comboPassword.getSelectedItem()).getValue(),
				                         editPassword1.getText(),
				                         editPassword2.getText());	
		if (sdkReturn != Return.SUCCESS) {
			DisplayError("Password", sdkReturn);
		}
	}

	//------------------------------------------------------------------------------------

	private void PasswordCmd() {
        if (((ComboItem)comboPassword.getSelectedItem()).getValue() == Password.USE) {
            labelPassword2.setEnabled(false);
            editPassword2.setEnabled(false);
        }
        else {
            labelPassword2.setEnabled(true);
            editPassword2.setEnabled(true);
        }
	}

	//------------------------------------------------------------------------------------

	void Read360()
	{
		byte     SDKReturn = Return.ERROR;
		Object	 temp;
		Param360 item = ParamSet[((ComboItem)comboParam360.getSelectedItem()).getValue()];
	
		switch (item.Type)
		{
		case AsInt:
			IntByReference tempint = new IntByReference();
            SDKReturn = SDK.ID_AccessInt(hSession, Action.READ, item.ID, tempint);
            temp = tempint.getValue();
			break;
	
		case AsBool:
            BOOLByReference tempbool = new BOOLByReference();
            SDKReturn = SDK.ID_AccessBool(hSession, Action.READ, item.ID, tempbool);
            temp = tempbool.getValue().booleanValue();
            break;
	
		default:
			StringBuilder tempString = new StringBuilder();
			SDKReturn = SDK.ID_AccessString(hSession, Action.READ, item.ID, tempString);
			temp = tempString;
		}
	
		if (SDKReturn != Return.SUCCESS) {
			DisplayError("GetPro360Param", SDKReturn);
		}
		else {
			textInfoMsg.append(item.Text + Separator(Action.READ) + temp.toString() + "\n\n");
		}
	}

	//------------------------------------------------------------------------------------

	void AllParams()
	{
	    byte   SDKReturn;
	    Object temp;

		CursorWait();

		for (Param360 item : ParamSet) {
	        switch (item.Type) {
	        case AsInt:
	            IntByReference tempint = new IntByReference();
	            SDKReturn = SDK.ID_AccessInt(hSession, Action.READ, item.ID, tempint);
	            temp = tempint.getValue();
	            break;
	
	        case AsBool:
	            BOOLByReference tempbool = new BOOLByReference();
	            SDKReturn = SDK.ID_AccessBool(hSession, Action.READ, item.ID, tempbool);
	            temp = tempbool.getValue().booleanValue();
	            break;

	        default:
	        	StringBuilder tempString = new StringBuilder();
	            SDKReturn = SDK.ID_AccessString(hSession, Action.READ, item.ID, tempString);
	            temp = tempString;
	        }
	
	        if (SDKReturn != Return.SUCCESS) {
				DisplayError("GetAllParams", SDKReturn);
	        }
	        else {
	        	textInfoMsg.append(item.Text
	        					   + Separator(Action.READ) 
	        					   + temp.toString().toUpperCase() 
	        					   + "\n");
	        }
	    }
		textInfoMsg.append("\n");

		CursorDefault();
	}
	
	//------------------------------------------------------------------------------------

	private void Sensors()
	{
		CursorWait();

		IntByReference sensors = new IntByReference();
		byte SDKReturn = SDK.ID_Sensors(hSession, sensors);
		if (SDKReturn != Return.SUCCESS) {
			DisplayError("Sensors", SDKReturn);
		}
		else
		{
			textInfoMsg.append("Sensors:" + "\n");
			if ((sensors.getValue() & Sensors.LID_SENSOR) != 0) 
				textInfoMsg.append("- Lid Closed\n");
			else
				textInfoMsg.append("- Lid Open\n");
			
			if ((sensors.getValue() & Sensors.HOPPER_VALID) == 0)
				textInfoMsg.append("- Hopper Sensor Not Fitted\n");
			else if ((sensors.getValue() & Sensors.HOPPER_SENSOR) != 0)
				textInfoMsg.append("- Cards in Hopper\n");
			else 
				textInfoMsg.append("- Cards Low\n");
			
			if ((sensors.getValue() & Sensors.EXIT_VALID) == 0)
				textInfoMsg.append("- Exit Sensor Not Fitted\n");
			else if ((sensors.getValue() & Sensors.EXIT_SENSOR) != 0)
				textInfoMsg.append("- Exit Blocked\n");
			else 
				textInfoMsg.append("- Exit Clear\n");
		}
		textInfoMsg.append("\n");

		CursorDefault();
	}

	//====================================================================================

	class ActionHandler implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			switch (e.getActionCommand()) {
			case CLEAR:      ClearMsg();      break;
			case LASTMSG:    LastMsg();       break;
			case SDKBITS:    SDKBits();       break;
			case STATUS:     PrinterStatus(); break;
			case INFO:       PrinterInfo();   break;
			case VERSION:    SDKVersion();    break;
			case CONNECTION: Connection();    break;
			case TYPE:       Type();          break;
			case MODEL:      Model();         break;
			case PASSWORD:   Password();      break;
			case PWDCMD:     PasswordCmd();   break;
			case READ360:    Read360();       break;
			case ALL360:     AllParams();     break;
			case SENSORS:    Sensors();       break;
			}
		}
	}
}
